
#ifndef _1_CRYS_SEP_ATP_DH_Acceptance_h_H
#define _1_CRYS_SEP_ATP_DH_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_SEP_ATP_Defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:56:19 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SEP_ATP_DH_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/

/******** Public Variables ********/
/******** Public Functions ********/
/***********************************************************************
* Function Name:                                                           
*  SEPQA_DH_PKCS3         
* 
* Inputs:
* Generator_ptr 		- Pointer to the Generator octet string
* GeneratorSize 		- Size of the Generator String (in bytes)
* Prime_ptr 			- Pointer to the Prime octet string
* PrimeSize 			- Size of the Prime string (in bytes)
* L 					- Relevant only for PKCS#3, the private value length in bits
*	If L != 0 then - force the private key to be 2^(L-1) <= Prv < 2^l
*	if L 0 then: 0< Prv < P-1
*	In ANSI X9.42 L is irrelevant  
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
* This function is qa external application on the SEP, 
* that executes the Diffie-Hellman key agreement 
*  scheme according to PKCS#3  
* Algorithm:   
* 1. Call the CRYS_DH_PKCS3_GeneratePubPrv function to 
*    generate a public and privet key for the client
* 2. Call the CRYS_DH_PKCS3_GeneratePubPrv function to 
*    generate a public and privet key for the Server
* 3. Call the CRYS_DH_PKCS3_GetSecretKey function to 
*    generate a secret key for the client  
* 4. Call the CRYS_DH_PKCS3_GetSecretKey function to 
*    generate a secret key for the Server
* 5. Compare the two secret keys - to verify they are identical                                                    
*
**************************************************************************************/                                
CRYSError_t SEPQA_DH_PKCS3( DxUint8_t *Generator_ptr,
							DxUint16_t GeneratorSize,
							DxUint8_t *Prime_ptr,
							DxUint16_t PrimeSize,
							DxUint16_t L,
							DxUint8_t   *FailureFunctionNameOut);

/***********************************************************************
* Function Name:                                                           
*  SEPQA_DH_ANSI942         
* 
* Inputs:
* Generator_ptr 		- Pointer to the Generator octet string
* GeneratorSize 		- Size of the Generator String (in bytes)
* Prime_ptr 			- Pointer to the Prime octet string
* PrimeSize 			- Size of the Prime string (in bytes)
* Q_ptr 				- Relevant only for ANSI X9.42 - Pointer to the Q octet string
*							1<= Prv <= q-1   or   1< Prv < q-1
* QSize	 			    - Relevant only for ANSI X9.42 - Size of the Q string (in bytes)  				 				  
* SecretDataGenType     - secret data gen type
* KeyGetSecretKeyType   - get secret key type
* KeyLenInBits          - key len in bits
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
* This function is qa external application on the SEP, 
* that executes the Diffie-Hellman key agreement 
*  scheme according to PKCS#3  
* Algorithm:   
* 1. Call the CRYS_DH_ANSI_X942_GeneratePubPrv function to 
*    generate a public and privet key for the client
* 2. Call the CRYS_DH_ANSI_X942_GeneratePubPrv function to 
*    generate a public and privet key for the Server
* 3. Repete steps 1 & 2 in case of Hybrid scheam
* 4. Check the server and client public keys according to their domain parameters
* 5. Call the CRYS_DH_X942_GetSecret_ASN1_2_Data
*             or 
* 	       CRYS_DH_X942_GetSecret_Concat_2_Data
*             and in case of Hybrid scheam
*             CRYS_DH_X942_Hybrid_GetSecret_ASN1_2_Data
*             or 
*             CRYS_DH_X942_Hybrid_GetSecret_Concat_2_Data
*     both for the server and the Client to generate the secret keys
* 6. Compare the two secret keys - to verify they are identical													
*
**************************************************************************************/                                
CRYSError_t SEPQA_DH_ANSI942(DxUint8_t *Generator_ptr,
							 DxUint16_t   GeneratorSize,
							 DxUint8_t   *Prime_ptr,
							 DxUint16_t   PrimeSize,
							 DxUint8_t   *Q_ptr,
							 DxUint16_t   QSize,
							 DxUint16_t   SecretDataGenType,
							 DxUint16_t   KeyGetSecretKeyType,
							 DxUint16_t	KeyLenInBits,
							 DxUint8_t   *FailureFunctionNameOut);


#ifdef __cplusplus
}
#endif

#endif


